/*****************************************************************************
*  LPC11U6x SCT blinky program
*
*  1. Use SCT1 timer to generate a 10 msec timer tick (interrupt driven).
*  2. Toggle P1_3 every 200 msec
*****************************************************************************/
#include "LPC11U6x.h"

extern void SCT1_Init(void);

void SCT0_1_IRQHandler(void)
{                                                  // SCT Interrupt Handler (10 msec)
  static uint8_t cnt = 0;

    if (++cnt > 20)                                // 20 * 10 msec = 200 msec
    {
        cnt = 0;
        LPC_GPIO_PORT->NOT[1] = (1 << 3);          // toggle pin P1_3
    }
    LPC_SCT1->EVFLAG = 0x00000001;                 // clear event 0 flag
}

int main (void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)        // enable clock for IOCON
                               | (1u << 31);       // enable clock for SCT0/1

    LPC_GPIO_PORT->DIR[1]     |= (1 << 3);         // configure P1.3 (LED) as output

    SCT1_Init();                                   // Initialize SCT1

    while (1)                                      // loop forever
    {
    }
}
